# Starfield example (BlitEngine/WiFiBoyMini)
# 2018.09.08, tklua@wifiboy.org

stars=[]; vstar=[]  # prepare starfield lists
nstar=100			# 100 stars
for i in range(nstar):
    stars.append(wb.rand() % 16384)  # star position on screen (0-16383)
    vstar.append((wb.rand() % 10)+1) # velocity of star (1-10)
# Start to show stars
while True:
    # clear off-screen buffer
    wb.blitbuf()
    # loop all stars
    for j in range(nstar):
        wb.blitbuf(stars[j],255) # draw one star in color#255 (white)
        stars[j] += 128*vstar[j] # move star to next position (add 128*v)
        if (stars[j]>16384): stars[j] -= 16384  # if out of screen, roll it back
    wb.blitstr("Hello!", 30, 50)
    wb.blit() # disply out
                                    